/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchema;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InventoryItemSchemaMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();
    private static final InventoryItemSchemaMarshaller INSTANCE = new InventoryItemSchemaMarshaller();

    private InventoryItemSchemaMarshaller() {
    }

    public static InventoryItemSchemaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryItemSchema inventoryItemSchema, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inventoryItemSchema, (String)"inventoryItemSchema");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inventoryItemSchema.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)inventoryItemSchema.version(), VERSION_BINDING);
            protocolMarshaller.marshall(inventoryItemSchema.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)inventoryItemSchema.displayName(), DISPLAYNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

