/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryAggregator;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InventoryAggregatorMarshaller {
    private static final MarshallingInfo<String> EXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expression").isBinary(false).build();
    private static final MarshallingInfo<List> AGGREGATORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aggregators").isBinary(false).build();
    private static final InventoryAggregatorMarshaller INSTANCE = new InventoryAggregatorMarshaller();

    private InventoryAggregatorMarshaller() {
    }

    public static InventoryAggregatorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryAggregator inventoryAggregator, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inventoryAggregator, (String)"inventoryAggregator");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inventoryAggregator.expression(), EXPRESSION_BINDING);
            protocolMarshaller.marshall(inventoryAggregator.aggregators(), AGGREGATORS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

