/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceInformationFilterMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").isBinary(false).build();
    private static final MarshallingInfo<List> VALUESET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("valueSet").isBinary(false).build();
    private static final InstanceInformationFilterMarshaller INSTANCE = new InstanceInformationFilterMarshaller();

    private InstanceInformationFilterMarshaller() {
    }

    public static InstanceInformationFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceInformationFilter instanceInformationFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceInformationFilter, (String)"instanceInformationFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceInformationFilter.keyAsString(), KEY_BINDING);
            protocolMarshaller.marshall(instanceInformationFilter.valueSet(), VALUESET_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

