/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.EffectivePatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EffectivePatchMarshaller {
    private static final MarshallingInfo<StructuredPojo> PATCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Patch").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PATCHSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchStatus").isBinary(false).build();
    private static final EffectivePatchMarshaller INSTANCE = new EffectivePatchMarshaller();

    private EffectivePatchMarshaller() {
    }

    public static EffectivePatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EffectivePatch effectivePatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)effectivePatch, (String)"effectivePatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)effectivePatch.patch(), PATCH_BINDING);
            protocolMarshaller.marshall((Object)effectivePatch.patchStatus(), PATCHSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

