/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentParameter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentParameterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultValue").isBinary(false).build();
    private static final DocumentParameterMarshaller INSTANCE = new DocumentParameterMarshaller();

    private DocumentParameterMarshaller() {
    }

    public static DocumentParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentParameter documentParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentParameter, (String)"documentParameter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentParameter.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentParameter.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)documentParameter.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)documentParameter.defaultValue(), DEFAULTVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

