/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.transform.DeletePatchBaselineRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeletePatchBaselineRequestMarshaller
implements Marshaller<Request<DeletePatchBaselineRequest>, DeletePatchBaselineRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonSSM.DeletePatchBaseline").serviceName("Amazon SSM").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DeletePatchBaselineRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeletePatchBaselineRequest> marshall(DeletePatchBaselineRequest deletePatchBaselineRequest) {
        Validate.paramNotNull((Object)((Object)deletePatchBaselineRequest), (String)"deletePatchBaselineRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)deletePatchBaselineRequest);
            protocolMarshaller.startMarshalling();
            DeletePatchBaselineRequestModelMarshaller.getInstance().marshall(deletePatchBaselineRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

