/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.SeveritySummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SeveritySummary
implements StructuredPojo,
ToCopyableBuilder<Builder, SeveritySummary> {
    private final Integer criticalCount;
    private final Integer highCount;
    private final Integer mediumCount;
    private final Integer lowCount;
    private final Integer informationalCount;
    private final Integer unspecifiedCount;

    private SeveritySummary(BuilderImpl builder) {
        this.criticalCount = builder.criticalCount;
        this.highCount = builder.highCount;
        this.mediumCount = builder.mediumCount;
        this.lowCount = builder.lowCount;
        this.informationalCount = builder.informationalCount;
        this.unspecifiedCount = builder.unspecifiedCount;
    }

    public Integer criticalCount() {
        return this.criticalCount;
    }

    public Integer highCount() {
        return this.highCount;
    }

    public Integer mediumCount() {
        return this.mediumCount;
    }

    public Integer lowCount() {
        return this.lowCount;
    }

    public Integer informationalCount() {
        return this.informationalCount;
    }

    public Integer unspecifiedCount() {
        return this.unspecifiedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.criticalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.highCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediumCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lowCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.informationalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unspecifiedCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeveritySummary)) {
            return false;
        }
        SeveritySummary other = (SeveritySummary)obj;
        return Objects.equals(this.criticalCount(), other.criticalCount()) && Objects.equals(this.highCount(), other.highCount()) && Objects.equals(this.mediumCount(), other.mediumCount()) && Objects.equals(this.lowCount(), other.lowCount()) && Objects.equals(this.informationalCount(), other.informationalCount()) && Objects.equals(this.unspecifiedCount(), other.unspecifiedCount());
    }

    public String toString() {
        return ToString.builder((String)"SeveritySummary").add("CriticalCount", (Object)this.criticalCount()).add("HighCount", (Object)this.highCount()).add("MediumCount", (Object)this.mediumCount()).add("LowCount", (Object)this.lowCount()).add("InformationalCount", (Object)this.informationalCount()).add("UnspecifiedCount", (Object)this.unspecifiedCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CriticalCount": {
                return Optional.ofNullable(clazz.cast(this.criticalCount()));
            }
            case "HighCount": {
                return Optional.ofNullable(clazz.cast(this.highCount()));
            }
            case "MediumCount": {
                return Optional.ofNullable(clazz.cast(this.mediumCount()));
            }
            case "LowCount": {
                return Optional.ofNullable(clazz.cast(this.lowCount()));
            }
            case "InformationalCount": {
                return Optional.ofNullable(clazz.cast(this.informationalCount()));
            }
            case "UnspecifiedCount": {
                return Optional.ofNullable(clazz.cast(this.unspecifiedCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SeveritySummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer criticalCount;
        private Integer highCount;
        private Integer mediumCount;
        private Integer lowCount;
        private Integer informationalCount;
        private Integer unspecifiedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SeveritySummary model) {
            this.criticalCount(model.criticalCount);
            this.highCount(model.highCount);
            this.mediumCount(model.mediumCount);
            this.lowCount(model.lowCount);
            this.informationalCount(model.informationalCount);
            this.unspecifiedCount(model.unspecifiedCount);
        }

        public final Integer getCriticalCount() {
            return this.criticalCount;
        }

        @Override
        public final Builder criticalCount(Integer criticalCount) {
            this.criticalCount = criticalCount;
            return this;
        }

        public final void setCriticalCount(Integer criticalCount) {
            this.criticalCount = criticalCount;
        }

        public final Integer getHighCount() {
            return this.highCount;
        }

        @Override
        public final Builder highCount(Integer highCount) {
            this.highCount = highCount;
            return this;
        }

        public final void setHighCount(Integer highCount) {
            this.highCount = highCount;
        }

        public final Integer getMediumCount() {
            return this.mediumCount;
        }

        @Override
        public final Builder mediumCount(Integer mediumCount) {
            this.mediumCount = mediumCount;
            return this;
        }

        public final void setMediumCount(Integer mediumCount) {
            this.mediumCount = mediumCount;
        }

        public final Integer getLowCount() {
            return this.lowCount;
        }

        @Override
        public final Builder lowCount(Integer lowCount) {
            this.lowCount = lowCount;
            return this;
        }

        public final void setLowCount(Integer lowCount) {
            this.lowCount = lowCount;
        }

        public final Integer getInformationalCount() {
            return this.informationalCount;
        }

        @Override
        public final Builder informationalCount(Integer informationalCount) {
            this.informationalCount = informationalCount;
            return this;
        }

        public final void setInformationalCount(Integer informationalCount) {
            this.informationalCount = informationalCount;
        }

        public final Integer getUnspecifiedCount() {
            return this.unspecifiedCount;
        }

        @Override
        public final Builder unspecifiedCount(Integer unspecifiedCount) {
            this.unspecifiedCount = unspecifiedCount;
            return this;
        }

        public final void setUnspecifiedCount(Integer unspecifiedCount) {
            this.unspecifiedCount = unspecifiedCount;
        }

        public SeveritySummary build() {
            return new SeveritySummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SeveritySummary> {
        public Builder criticalCount(Integer var1);

        public Builder highCount(Integer var1);

        public Builder mediumCount(Integer var1);

        public Builder lowCount(Integer var1);

        public Builder informationalCount(Integer var1);

        public Builder unspecifiedCount(Integer var1);
    }
}

