/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequestEntriesCopier;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequestEntry;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssociationBatchRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateAssociationBatchRequest> {
    private final List<CreateAssociationBatchRequestEntry> entries;

    private CreateAssociationBatchRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
    }

    public List<CreateAssociationBatchRequestEntry> entries() {
        return this.entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchRequest)) {
            return false;
        }
        CreateAssociationBatchRequest other = (CreateAssociationBatchRequest)((Object)obj);
        return Objects.equals(this.entries(), other.entries());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssociationBatchRequest").add("Entries", this.entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<CreateAssociationBatchRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchRequest model) {
            super(model);
            this.entries(model.entries);
        }

        public final Collection<CreateAssociationBatchRequestEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(CreateAssociationBatchRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<CreateAssociationBatchRequestEntry> entries) {
            this.entries = CreateAssociationBatchRequestEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(CreateAssociationBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<CreateAssociationBatchRequestEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (CreateAssociationBatchRequestEntry)((CreateAssociationBatchRequestEntry.Builder)CreateAssociationBatchRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<CreateAssociationBatchRequestEntry.BuilderImpl> entries) {
            this.entries = CreateAssociationBatchRequestEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssociationBatchRequest build() {
            return new CreateAssociationBatchRequest(this);
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    CopyableBuilder<Builder, CreateAssociationBatchRequest> {
        public Builder entries(Collection<CreateAssociationBatchRequestEntry> var1);

        public Builder entries(CreateAssociationBatchRequestEntry ... var1);

        public Builder entries(Consumer<CreateAssociationBatchRequestEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

