/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PatchFilterGroupMarshaller {
    private static final MarshallingInfo<List> PATCHFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchFilters").isBinary(false).build();
    private static final PatchFilterGroupMarshaller INSTANCE = new PatchFilterGroupMarshaller();

    private PatchFilterGroupMarshaller() {
    }

    public static PatchFilterGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchFilterGroup patchFilterGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)patchFilterGroup, (String)"patchFilterGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(patchFilterGroup.patchFilters(), PATCHFILTERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

