/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComplianceExecutionSummaryMarshaller {
    private static final MarshallingInfo<Instant> EXECUTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTime").isBinary(false).build();
    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> EXECUTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionType").isBinary(false).build();
    private static final ComplianceExecutionSummaryMarshaller INSTANCE = new ComplianceExecutionSummaryMarshaller();

    private ComplianceExecutionSummaryMarshaller() {
    }

    public static ComplianceExecutionSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComplianceExecutionSummary complianceExecutionSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)complianceExecutionSummary, (String)"complianceExecutionSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)complianceExecutionSummary.executionTime(), EXECUTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)complianceExecutionSummary.executionId(), EXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)complianceExecutionSummary.executionType(), EXECUTIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

