/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.Association;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;

public class ListAssociationsPublisher
implements SdkPublisher<ListAssociationsResponse> {
    private final SsmAsyncClient client;
    private final ListAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociationsPublisher(SsmAsyncClient client, ListAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociationsPublisher(SsmAsyncClient client, ListAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Association> associations() {
        Function<ListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListAssociationsPublisher resume(ListAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAssociationsPublisher(this.client, (ListAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAssociationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAssociationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAssociationsResponseFetcher
    implements AsyncPageFetcher<ListAssociationsResponse> {
        private ListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListAssociationsResponse> nextPage(ListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationsPublisher.this.client.listAssociations(ListAssociationsPublisher.this.firstRequest);
            }
            return ListAssociationsPublisher.this.client.listAssociations((ListAssociationsRequest)((Object)ListAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

