/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;

public class GetParametersByPathIterable
implements SdkIterable<GetParametersByPathResponse> {
    private final SsmClient client;
    private final GetParametersByPathRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetParametersByPathIterable(SsmClient client, GetParametersByPathRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetParametersByPathResponseFetcher();
    }

    public Iterator<GetParametersByPathResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetParametersByPathIterable resume(GetParametersByPathResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetParametersByPathIterable(this.client, (GetParametersByPathRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetParametersByPathIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetParametersByPathResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetParametersByPathResponseFetcher
    implements SyncPageFetcher<GetParametersByPathResponse> {
        private GetParametersByPathResponseFetcher() {
        }

        public boolean hasNextPage(GetParametersByPathResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetParametersByPathResponse nextPage(GetParametersByPathResponse previousPage) {
            if (previousPage == null) {
                return GetParametersByPathIterable.this.client.getParametersByPath(GetParametersByPathIterable.this.firstRequest);
            }
            return GetParametersByPathIterable.this.client.getParametersByPath((GetParametersByPathRequest)((Object)GetParametersByPathIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

