/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryItem;
import software.amazon.awssdk.services.ssm.model.InventoryItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInventoryRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, PutInventoryRequest> {
    private final String instanceId;
    private final List<InventoryItem> items;

    private PutInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.items = builder.items;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<InventoryItem> items() {
        return this.items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInventoryRequest)) {
            return false;
        }
        PutInventoryRequest other = (PutInventoryRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"PutInventoryRequest").add("InstanceId", (Object)this.instanceId()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private List<InventoryItem> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInventoryRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.items(model.items);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<InventoryItem.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(InventoryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<InventoryItem> items) {
            this.items = InventoryItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(InventoryItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<InventoryItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (InventoryItem)((InventoryItem.Builder)InventoryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<InventoryItem.BuilderImpl> items) {
            this.items = InventoryItemListCopier.copyFromBuilder(items);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInventoryRequest build() {
            return new PutInventoryRequest(this);
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    CopyableBuilder<Builder, PutInventoryRequest> {
        public Builder instanceId(String var1);

        public Builder items(Collection<InventoryItem> var1);

        public Builder items(InventoryItem ... var1);

        public Builder items(Consumer<InventoryItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

