/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DocumentVersionInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentVersionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentVersionInfo> {
    private final String name;
    private final String documentVersion;
    private final Instant createdDate;
    private final Boolean isDefaultVersion;

    private DocumentVersionInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.createdDate = builder.createdDate;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionInfo)) {
            return false;
        }
        DocumentVersionInfo other = (DocumentVersionInfo)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion());
    }

    public String toString() {
        return ToString.builder((String)"DocumentVersionInfo").add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("CreatedDate", (Object)this.createdDate()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "IsDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentVersionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String documentVersion;
        private Instant createdDate;
        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionInfo model) {
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.createdDate(model.createdDate);
            this.isDefaultVersion(model.isDefaultVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public DocumentVersionInfo build() {
            return new DocumentVersionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentVersionInfo> {
        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder createdDate(Instant var1);

        public Builder isDefaultVersion(Boolean var1);
    }
}

