/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationBatchRequestEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssociationBatchRequestEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateAssociationBatchRequestEntry> {
    private final String name;
    private final String instanceId;
    private final Map<String, List<String>> parameters;
    private final String documentVersion;
    private final List<Target> targets;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final String associationName;

    private CreateAssociationBatchRequestEntry(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.parameters = builder.parameters;
        this.documentVersion = builder.documentVersion;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.associationName = builder.associationName;
    }

    public String name() {
        return this.name;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public String associationName() {
        return this.associationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchRequestEntry)) {
            return false;
        }
        CreateAssociationBatchRequestEntry other = (CreateAssociationBatchRequestEntry)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.associationName(), other.associationName());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssociationBatchRequestEntry").add("Name", (Object)this.name()).add("InstanceId", (Object)this.instanceId()).add("Parameters", this.parameters()).add("DocumentVersion", (Object)this.documentVersion()).add("Targets", this.targets()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("OutputLocation", (Object)this.outputLocation()).add("AssociationName", (Object)this.associationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "AssociationName": {
                return Optional.ofNullable(clazz.cast(this.associationName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateAssociationBatchRequestEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String documentVersion;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private String associationName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchRequestEntry model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.parameters(model.parameters);
            this.documentVersion(model.documentVersion);
            this.targets(model.targets);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.associationName(model.associationName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public CreateAssociationBatchRequestEntry build() {
            return new CreateAssociationBatchRequestEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAssociationBatchRequestEntry> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder documentVersion(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        default public Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return this.outputLocation((InstanceAssociationOutputLocation)((InstanceAssociationOutputLocation.Builder)InstanceAssociationOutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder associationName(String var1);
    }
}

