/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PatchRuleGroupMarshaller {
    private static final MarshallingInfo<List> PATCHRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchRules").isBinary(false).build();
    private static final PatchRuleGroupMarshaller INSTANCE = new PatchRuleGroupMarshaller();

    private PatchRuleGroupMarshaller() {
    }

    public static PatchRuleGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchRuleGroup patchRuleGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)patchRuleGroup, (String)"patchRuleGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(patchRuleGroup.patchRules(), PATCHRULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

