/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentFilterMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final DocumentFilterMarshaller INSTANCE = new DocumentFilterMarshaller();

    private DocumentFilterMarshaller() {
    }

    public static DocumentFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentFilter documentFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentFilter, (String)"documentFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentFilter.keyAsString(), KEY_BINDING);
            protocolMarshaller.marshall((Object)documentFilter.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

