/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateActivationRequestModelMarshaller {
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTINSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultInstanceName").isBinary(false).build();
    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").isBinary(false).build();
    private static final MarshallingInfo<Integer> REGISTRATIONLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationLimit").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").isBinary(false).build();
    private static final CreateActivationRequestModelMarshaller INSTANCE = new CreateActivationRequestModelMarshaller();

    private CreateActivationRequestModelMarshaller() {
    }

    public static CreateActivationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateActivationRequest createActivationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createActivationRequest), (String)"createActivationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createActivationRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createActivationRequest.defaultInstanceName(), DEFAULTINSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)createActivationRequest.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall((Object)createActivationRequest.registrationLimit(), REGISTRATIONLIMIT_BINDING);
            protocolMarshaller.marshall((Object)createActivationRequest.expirationDate(), EXPIRATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

