/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;

public class ListCommandsIterable
implements SdkIterable<ListCommandsResponse> {
    private final SSMClient client;
    private final ListCommandsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandsIterable(SSMClient client, ListCommandsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCommandsResponseFetcher();
    }

    public Iterator<ListCommandsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Command> commands() {
        Function<ListCommandsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commands() != null) {
                return response.commands().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListCommandsIterable resume(ListCommandsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCommandsIterable(this.client, (ListCommandsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCommandsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCommandsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCommandsResponseFetcher
    implements SyncPageFetcher<ListCommandsResponse> {
        private ListCommandsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCommandsResponse nextPage(ListCommandsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandsIterable.this.client.listCommands(ListCommandsIterable.this.firstRequest);
            }
            return ListCommandsIterable.this.client.listCommands((ListCommandsRequest)((Object)ListCommandsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

