/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ssm.SSMAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;

public class GetParametersByPathPublisher
implements SdkPublisher<GetParametersByPathResponse> {
    private final SSMAsyncClient client;
    private final GetParametersByPathRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetParametersByPathPublisher(SSMAsyncClient client, GetParametersByPathRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetParametersByPathPublisher(SSMAsyncClient client, GetParametersByPathRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetParametersByPathResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetParametersByPathResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetParametersByPathPublisher resume(GetParametersByPathResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetParametersByPathPublisher(this.client, (GetParametersByPathRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetParametersByPathPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetParametersByPathResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetParametersByPathResponseFetcher
    implements AsyncPageFetcher<GetParametersByPathResponse> {
        private GetParametersByPathResponseFetcher() {
        }

        public boolean hasNextPage(GetParametersByPathResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetParametersByPathResponse> nextPage(GetParametersByPathResponse previousPage) {
            if (previousPage == null) {
                return GetParametersByPathPublisher.this.client.getParametersByPath(GetParametersByPathPublisher.this.firstRequest);
            }
            return GetParametersByPathPublisher.this.client.getParametersByPath((GetParametersByPathRequest)((Object)GetParametersByPathPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

