/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;

public class DescribeInstanceInformationIterable
implements SdkIterable<DescribeInstanceInformationResponse> {
    private final SSMClient client;
    private final DescribeInstanceInformationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceInformationIterable(SSMClient client, DescribeInstanceInformationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceInformationResponseFetcher();
    }

    public Iterator<DescribeInstanceInformationResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<InstanceInformation> instanceInformationList() {
        Function<DescribeInstanceInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceInformationList() != null) {
                return response.instanceInformationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeInstanceInformationIterable resume(DescribeInstanceInformationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstanceInformationIterable(this.client, (DescribeInstanceInformationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstanceInformationIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeInstanceInformationResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeInstanceInformationResponseFetcher
    implements SyncPageFetcher<DescribeInstanceInformationResponse> {
        private DescribeInstanceInformationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceInformationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeInstanceInformationResponse nextPage(DescribeInstanceInformationResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceInformationIterable.this.client.describeInstanceInformation(DescribeInstanceInformationIterable.this.firstRequest);
            }
            return DescribeInstanceInformationIterable.this.client.describeInstanceInformation((DescribeInstanceInformationRequest)((Object)DescribeInstanceInformationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

