/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.services.ssm.model.SignalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendAutomationSignalRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, SendAutomationSignalRequest> {
    private final String automationExecutionId;
    private final String signalType;
    private final Map<String, List<String>> payload;

    private SendAutomationSignalRequest(BuilderImpl builder) {
        super(builder);
        this.automationExecutionId = builder.automationExecutionId;
        this.signalType = builder.signalType;
        this.payload = builder.payload;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public SignalType signalType() {
        return SignalType.fromValue(this.signalType);
    }

    public String signalTypeAsString() {
        return this.signalType;
    }

    public Map<String, List<String>> payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAutomationSignalRequest)) {
            return false;
        }
        SendAutomationSignalRequest other = (SendAutomationSignalRequest)((Object)obj);
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.signalTypeAsString(), other.signalTypeAsString()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        return ToString.builder((String)"SendAutomationSignalRequest").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("SignalType", (Object)this.signalTypeAsString()).add("Payload", this.payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.of(clazz.cast(this.automationExecutionId()));
            }
            case "SignalType": {
                return Optional.of(clazz.cast(this.signalTypeAsString()));
            }
            case "Payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String signalType;
        private Map<String, List<String>> payload;

        private BuilderImpl() {
        }

        private BuilderImpl(SendAutomationSignalRequest model) {
            super(model);
            this.automationExecutionId(model.automationExecutionId);
            this.signalType(model.signalType);
            this.payload(model.payload);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getSignalType() {
            return this.signalType;
        }

        @Override
        public final Builder signalType(String signalType) {
            this.signalType = signalType;
            return this;
        }

        @Override
        public final Builder signalType(SignalType signalType) {
            this.signalType(signalType.toString());
            return this;
        }

        public final void setSignalType(String signalType) {
            this.signalType = signalType;
        }

        public final Map<String, ? extends Collection<String>> getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
            return this;
        }

        public final void setPayload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendAutomationSignalRequest build() {
            return new SendAutomationSignalRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, SendAutomationSignalRequest> {
        public Builder automationExecutionId(String var1);

        public Builder signalType(String var1);

        public Builder signalType(SignalType var1);

        public Builder payload(Map<String, ? extends Collection<String>> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

