/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchFilter;
import software.amazon.awssdk.services.ssm.model.PatchFilterListCopier;
import software.amazon.awssdk.services.ssm.transform.PatchFilterGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchFilterGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchFilterGroup> {
    private final List<PatchFilter> patchFilters;

    private PatchFilterGroup(BuilderImpl builder) {
        this.patchFilters = builder.patchFilters;
    }

    public List<PatchFilter> patchFilters() {
        return this.patchFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchFilters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilterGroup)) {
            return false;
        }
        PatchFilterGroup other = (PatchFilterGroup)obj;
        return Objects.equals(this.patchFilters(), other.patchFilters());
    }

    public String toString() {
        return ToString.builder((String)"PatchFilterGroup").add("PatchFilters", this.patchFilters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchFilters": {
                return Optional.of(clazz.cast(this.patchFilters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchFilterGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PatchFilter> patchFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilterGroup model) {
            this.patchFilters(model.patchFilters);
        }

        public final Collection<PatchFilter.Builder> getPatchFilters() {
            return this.patchFilters != null ? (Collection)this.patchFilters.stream().map(PatchFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(PatchFilter ... patchFilters) {
            this.patchFilters(Arrays.asList(patchFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(Consumer<PatchFilter.Builder> ... patchFilters) {
            this.patchFilters(Stream.of(patchFilters).map(c -> (PatchFilter)((PatchFilter.Builder)PatchFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchFilters(Collection<PatchFilter.BuilderImpl> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copyFromBuilder(patchFilters);
        }

        public PatchFilterGroup build() {
            return new PatchFilterGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchFilterGroup> {
        public Builder patchFilters(Collection<PatchFilter> var1);

        public Builder patchFilters(PatchFilter ... var1);

        public Builder patchFilters(Consumer<PatchFilter.Builder> ... var1);
    }
}

