/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryFilterValueListCopier;
import software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType;
import software.amazon.awssdk.services.ssm.transform.InventoryFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryFilter> {
    private final String key;
    private final List<String> values;
    private final String type;

    private InventoryFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.type = builder.type;
    }

    public String key() {
        return this.key;
    }

    public List<String> values() {
        return this.values;
    }

    public InventoryQueryOperatorType type() {
        return InventoryQueryOperatorType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryFilter)) {
            return false;
        }
        InventoryFilter other = (InventoryFilter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"InventoryFilter").add("Key", (Object)this.key()).add("Values", this.values()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryFilter model) {
            this.key(model.key);
            this.values(model.values);
            this.type(model.type);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = InventoryFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = InventoryFilterValueListCopier.copy(values);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InventoryQueryOperatorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public InventoryFilter build() {
            return new InventoryFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryFilter> {
        public Builder key(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder type(String var1);

        public Builder type(InventoryQueryOperatorType var1);
    }
}

