/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterListCopier;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetParametersResponse> {
    private final List<Parameter> parameters;
    private final List<String> invalidParameters;

    private GetParametersResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.invalidParameters = builder.invalidParameters;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<String> invalidParameters() {
        return this.invalidParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersResponse)) {
            return false;
        }
        GetParametersResponse other = (GetParametersResponse)((Object)obj);
        return Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.invalidParameters(), other.invalidParameters());
    }

    public String toString() {
        return ToString.builder((String)"GetParametersResponse").add("Parameters", this.parameters()).add("InvalidParameters", this.invalidParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "InvalidParameters": {
                return Optional.of(clazz.cast(this.invalidParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<Parameter> parameters;
        private List<String> invalidParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersResponse model) {
            super(model);
            this.parameters(model.parameters);
            this.invalidParameters(model.invalidParameters);
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParameterListCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getInvalidParameters() {
            return this.invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String ... invalidParameters) {
            this.invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @Override
        public GetParametersResponse build() {
            return new GetParametersResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetParametersResponse> {
        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder invalidParameters(Collection<String> var1);

        public Builder invalidParameters(String ... var1);
    }
}

