/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetMaintenanceWindowResponse> {
    private final String windowId;
    private final String name;
    private final String description;
    private final String schedule;
    private final Integer duration;
    private final Integer cutoff;
    private final Boolean allowUnassociatedTargets;
    private final Boolean enabled;
    private final Instant createdDate;
    private final Instant modifiedDate;

    private GetMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
    }

    public String windowId() {
        return this.windowId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String schedule() {
        return this.schedule;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer cutoff() {
        return this.cutoff;
    }

    public Boolean allowUnassociatedTargets() {
        return this.allowUnassociatedTargets;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant modifiedDate() {
        return this.modifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowResponse)) {
            return false;
        }
        GetMaintenanceWindowResponse other = (GetMaintenanceWindowResponse)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.allowUnassociatedTargets(), other.allowUnassociatedTargets()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.modifiedDate(), other.modifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"GetMaintenanceWindowResponse").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Schedule", (Object)this.schedule()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("AllowUnassociatedTargets", (Object)this.allowUnassociatedTargets()).add("Enabled", (Object)this.enabled()).add("CreatedDate", (Object)this.createdDate()).add("ModifiedDate", (Object)this.modifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.of(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.of(clazz.cast(this.cutoff()));
            }
            case "AllowUnassociatedTargets": {
                return Optional.of(clazz.cast(this.allowUnassociatedTargets()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "CreatedDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "ModifiedDate": {
                return Optional.of(clazz.cast(this.modifiedDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String description;
        private String schedule;
        private Integer duration;
        private Integer cutoff;
        private Boolean allowUnassociatedTargets;
        private Boolean enabled;
        private Instant createdDate;
        private Instant modifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowResponse model) {
            super(model);
            this.windowId(model.windowId);
            this.name(model.name);
            this.description(model.description);
            this.schedule(model.schedule);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.allowUnassociatedTargets(model.allowUnassociatedTargets);
            this.enabled(model.enabled);
            this.createdDate(model.createdDate);
            this.modifiedDate(model.modifiedDate);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return this.allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return this.modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        @Override
        public GetMaintenanceWindowResponse build() {
            return new GetMaintenanceWindowResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetMaintenanceWindowResponse> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder schedule(String var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder allowUnassociatedTargets(Boolean var1);

        public Builder enabled(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder modifiedDate(Instant var1);
    }
}

