/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.services.ssm.transform.DocumentIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentIdentifier> {
    private final String name;
    private final String owner;
    private final List<String> platformTypes;
    private final String documentVersion;
    private final String documentType;
    private final String schemaVersion;
    private final List<Tag> tags;

    private DocumentIdentifier(BuilderImpl builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.platformTypes = builder.platformTypes;
        this.documentVersion = builder.documentVersion;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public List<PlatformType> platformTypes() {
        return TypeConverter.convert(this.platformTypes, PlatformType::fromValue);
    }

    public List<String> platformTypesAsStrings() {
        return this.platformTypes;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public String documentTypeAsString() {
        return this.documentType;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.platformTypesAsStrings(), other.platformTypesAsStrings()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DocumentIdentifier").add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("PlatformTypes", this.platformTypesAsStrings()).add("DocumentVersion", (Object)this.documentVersion()).add("DocumentType", (Object)this.documentTypeAsString()).add("SchemaVersion", (Object)this.schemaVersion()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "PlatformTypes": {
                return Optional.of(clazz.cast(this.platformTypesAsStrings()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "DocumentType": {
                return Optional.of(clazz.cast(this.documentTypeAsString()));
            }
            case "SchemaVersion": {
                return Optional.of(clazz.cast(this.schemaVersion()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String owner;
        private List<String> platformTypes;
        private String documentVersion;
        private String documentType;
        private String schemaVersion;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdentifier model) {
            this.name(model.name);
            this.owner(model.owner);
            this.platformTypes(model.platformTypes);
            this.documentVersion(model.documentVersion);
            this.documentType(model.documentType);
            this.schemaVersion(model.schemaVersion);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getPlatformTypes() {
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(String ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public DocumentIdentifier build() {
            return new DocumentIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentIdentifier> {
        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder platformTypes(Collection<String> var1);

        public Builder platformTypes(String ... var1);

        public Builder documentVersion(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

