/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteActivationRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, DeleteActivationRequest> {
    private final String activationId;

    private DeleteActivationRequest(BuilderImpl builder) {
        super(builder);
        this.activationId = builder.activationId;
    }

    public String activationId() {
        return this.activationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteActivationRequest)) {
            return false;
        }
        DeleteActivationRequest other = (DeleteActivationRequest)((Object)obj);
        return Objects.equals(this.activationId(), other.activationId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteActivationRequest").add("ActivationId", (Object)this.activationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationId": {
                return Optional.of(clazz.cast(this.activationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String activationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteActivationRequest model) {
            super(model);
            this.activationId(model.activationId);
        }

        public final String getActivationId() {
            return this.activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteActivationRequest build() {
            return new DeleteActivationRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, DeleteActivationRequest> {
        public Builder activationId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

