/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;

@SdkInternalApi
public class ListDocumentsRequestModelMarshaller {
    private static final MarshallingInfo<List> DOCUMENTFILTERLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentFilterList").build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final ListDocumentsRequestModelMarshaller instance = new ListDocumentsRequestModelMarshaller();

    public static ListDocumentsRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(ListDocumentsRequest listDocumentsRequest, ProtocolMarshaller protocolMarshaller) {
        if (listDocumentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(listDocumentsRequest.documentFilterList(), DOCUMENTFILTERLIST_BINDING);
            protocolMarshaller.marshall((Object)listDocumentsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listDocumentsRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

