/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;

@SdkInternalApi
public class InstanceInformationMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> PINGSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PingStatus").build();
    private static final MarshallingInfo<Date> LASTPINGDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastPingDateTime").build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").build();
    private static final MarshallingInfo<Boolean> ISLATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsLatestVersion").build();
    private static final MarshallingInfo<String> PLATFORMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformType").build();
    private static final MarshallingInfo<String> PLATFORMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformName").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").build();
    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").build();
    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").build();
    private static final MarshallingInfo<Date> REGISTRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationDate").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPAddress").build();
    private static final MarshallingInfo<String> COMPUTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerName").build();
    private static final MarshallingInfo<String> ASSOCIATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationStatus").build();
    private static final MarshallingInfo<Date> LASTASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAssociationExecutionDate").build();
    private static final MarshallingInfo<Date> LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulAssociationExecutionDate").build();
    private static final MarshallingInfo<StructuredPojo> ASSOCIATIONOVERVIEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationOverview").build();
    private static final InstanceInformationMarshaller instance = new InstanceInformationMarshaller();

    public static InstanceInformationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceInformation instanceInformation, ProtocolMarshaller protocolMarshaller) {
        if (instanceInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceInformation.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.pingStatus(), PINGSTATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.lastPingDateTime(), LASTPINGDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.isLatestVersion(), ISLATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.platformType(), PLATFORMTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.platformName(), PLATFORMNAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.platformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.activationId(), ACTIVATIONID_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.registrationDate(), REGISTRATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.computerName(), COMPUTERNAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.associationStatus(), ASSOCIATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.lastAssociationExecutionDate(), LASTASSOCIATIONEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.lastSuccessfulAssociationExecutionDate(), LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.associationOverview(), ASSOCIATIONOVERVIEW_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

