/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;

@SdkInternalApi
public class CreateDocumentRequestModelMarshaller {
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();
    private static final CreateDocumentRequestModelMarshaller instance = new CreateDocumentRequestModelMarshaller();

    public static CreateDocumentRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateDocumentRequest createDocumentRequest, ProtocolMarshaller protocolMarshaller) {
        if (createDocumentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createDocumentRequest.content(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)createDocumentRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createDocumentRequest.documentType(), DOCUMENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

