/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.model.StepExecutionListCopier;
import software.amazon.awssdk.services.ssm.transform.AutomationExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutomationExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, AutomationExecution> {
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final Date executionStartTime;
    private final Date executionEndTime;
    private final String automationExecutionStatus;
    private final List<StepExecution> stepExecutions;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> outputs;
    private final String failureMessage;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Date executionStartTime() {
        return this.executionStartTime;
    }

    public Date executionEndTime() {
        return this.executionEndTime;
    }

    public String automationExecutionStatus() {
        return this.automationExecutionStatus;
    }

    public List<StepExecution> stepExecutions() {
        return this.stepExecutions;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.automationExecutionId() == null ? 0 : this.automationExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.documentName() == null ? 0 : this.documentName().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.executionStartTime() == null ? 0 : this.executionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.executionEndTime() == null ? 0 : this.executionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.automationExecutionStatus() == null ? 0 : this.automationExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.stepExecutions() == null ? 0 : this.stepExecutions().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.failureMessage() == null ? 0 : this.failureMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        if (other.automationExecutionId() == null ^ this.automationExecutionId() == null) {
            return false;
        }
        if (other.automationExecutionId() != null && !other.automationExecutionId().equals(this.automationExecutionId())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.automationExecutionStatus() == null ^ this.automationExecutionStatus() == null) {
            return false;
        }
        if (other.automationExecutionStatus() != null && !other.automationExecutionStatus().equals(this.automationExecutionStatus())) {
            return false;
        }
        if (other.stepExecutions() == null ^ this.stepExecutions() == null) {
            return false;
        }
        if (other.stepExecutions() != null && !other.stepExecutions().equals(this.stepExecutions())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        return other.failureMessage() == null || other.failureMessage().equals(this.failureMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(this.automationExecutionId()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.executionStartTime()).append(",");
        }
        if (this.executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.executionEndTime()).append(",");
        }
        if (this.automationExecutionStatus() != null) {
            sb.append("AutomationExecutionStatus: ").append(this.automationExecutionStatus()).append(",");
        }
        if (this.stepExecutions() != null) {
            sb.append("StepExecutions: ").append(this.stepExecutions()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.failureMessage() != null) {
            sb.append("FailureMessage: ").append(this.failureMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private Date executionStartTime;
        private Date executionEndTime;
        private String automationExecutionStatus;
        private List<StepExecution> stepExecutions = new SdkInternalList();
        private Map<String, List<String>> parameters;
        private Map<String, List<String>> outputs;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            this.setAutomationExecutionId(model.automationExecutionId);
            this.setDocumentName(model.documentName);
            this.setDocumentVersion(model.documentVersion);
            this.setExecutionStartTime(model.executionStartTime);
            this.setExecutionEndTime(model.executionEndTime);
            this.setAutomationExecutionStatus(model.automationExecutionStatus);
            this.setStepExecutions(model.stepExecutions);
            this.setParameters(model.parameters);
            this.setOutputs(model.outputs);
            this.setFailureMessage(model.failureMessage);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Date getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy((Date)executionStartTime);
            return this;
        }

        public final void setExecutionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy((Date)executionStartTime);
        }

        public final Date getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy((Date)executionEndTime);
            return this;
        }

        public final void setExecutionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy((Date)executionEndTime);
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
        }

        public final Collection<StepExecution> getStepExecutions() {
            return this.stepExecutions;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution ... stepExecutions) {
            if (this.stepExecutions == null) {
                this.stepExecutions = new SdkInternalList(stepExecutions.length);
            }
            for (StepExecution e : stepExecutions) {
                this.stepExecutions.add(e);
            }
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
        }

        @SafeVarargs
        public final void setStepExecutions(StepExecution ... stepExecutions) {
            if (this.stepExecutions == null) {
                this.stepExecutions = new SdkInternalList(stepExecutions.length);
            }
            for (StepExecution e : stepExecutions) {
                this.stepExecutions.add(e);
            }
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public AutomationExecution build() {
            return new AutomationExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutomationExecution> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder executionStartTime(Date var1);

        public Builder executionEndTime(Date var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder stepExecutions(Collection<StepExecution> var1);

        public Builder stepExecutions(StepExecution ... var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder failureMessage(String var1);
    }
}

