/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.AssociationStatusName;
import software.amazon.awssdk.services.ssm.transform.AssociationStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationStatus> {
    private final Date dateValue;
    private final String name;
    private final String message;
    private final String additionalInfo;

    private AssociationStatus(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.name = builder.name;
        this.message = builder.message;
        this.additionalInfo = builder.additionalInfo;
    }

    public Date date() {
        return this.dateValue;
    }

    public String name() {
        return this.name;
    }

    public String message() {
        return this.message;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.date() == null ? 0 : this.date().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationStatus)) {
            return false;
        }
        AssociationStatus other = (AssociationStatus)obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        return other.additionalInfo() == null || other.additionalInfo().equals(this.additionalInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.date() != null) {
            sb.append("Date: ").append(this.date()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date dateValue;
        private String name;
        private String message;
        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationStatus model) {
            this.setDate(model.dateValue);
            this.setName(model.name);
            this.setMessage(model.message);
            this.setAdditionalInfo(model.additionalInfo);
        }

        public final Date getDate() {
            return this.dateValue;
        }

        @Override
        public final Builder date(Date dateValue) {
            this.dateValue = StandardMemberCopier.copy((Date)dateValue);
            return this;
        }

        public final void setDate(Date dateValue) {
            this.dateValue = StandardMemberCopier.copy((Date)dateValue);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AssociationStatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final void setName(AssociationStatusName name) {
            this.name(name.toString());
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public AssociationStatus build() {
            return new AssociationStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationStatus> {
        public Builder date(Date var1);

        public Builder name(String var1);

        public Builder name(AssociationStatusName var1);

        public Builder message(String var1);

        public Builder additionalInfo(String var1);
    }
}

