/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.BatchEntryIdsNotDistinctException;
import software.amazon.awssdk.services.sqs.model.BatchRequestTooLongException;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.EmptyBatchRequestException;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.InvalidAttributeNameException;
import software.amazon.awssdk.services.sqs.model.InvalidBatchEntryIdException;
import software.amazon.awssdk.services.sqs.model.InvalidIdFormatException;
import software.amazon.awssdk.services.sqs.model.InvalidMessageContentsException;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.MessageNotInflightException;
import software.amazon.awssdk.services.sqs.model.OverLimitException;
import software.amazon.awssdk.services.sqs.model.PurgeQueueInProgressException;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.QueueDeletedRecentlyException;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.QueueNameExistsException;
import software.amazon.awssdk.services.sqs.model.ReceiptHandleIsInvalidException;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.SqsException;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.services.sqs.model.TagQueueRequest;
import software.amazon.awssdk.services.sqs.model.TagQueueResponse;
import software.amazon.awssdk.services.sqs.model.TooManyEntriesInBatchRequestException;
import software.amazon.awssdk.services.sqs.model.UnsupportedOperationException;
import software.amazon.awssdk.services.sqs.model.UntagQueueRequest;
import software.amazon.awssdk.services.sqs.model.UntagQueueResponse;
import software.amazon.awssdk.services.sqs.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueUrlRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListDeadLetterSourceQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueueTagsRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiveMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.TagQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.UntagQueueRequestMarshaller;

@SdkInternalApi
final class DefaultSqsClient
implements SqsClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSqsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "sqs";
    }

    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws OverLimitException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddPermissionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addPermissionRequest).withMarshaller((Marshaller)new AddPermissionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ChangeMessageVisibilityResponse changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws MessageNotInflightException, ReceiptHandleIsInvalidException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ChangeMessageVisibilityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ChangeMessageVisibilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeMessageVisibility").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)changeMessageVisibilityRequest).withMarshaller((Marshaller)new ChangeMessageVisibilityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws TooManyEntriesInBatchRequestException, EmptyBatchRequestException, BatchEntryIdsNotDistinctException, InvalidBatchEntryIdException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ChangeMessageVisibilityBatchResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ChangeMessageVisibilityBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeMessageVisibilityBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)changeMessageVisibilityBatchRequest).withMarshaller((Marshaller)new ChangeMessageVisibilityBatchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws QueueDeletedRecentlyException, QueueNameExistsException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateQueueResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createQueueRequest).withMarshaller((Marshaller)new CreateQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteMessageResponse deleteMessage(DeleteMessageRequest deleteMessageRequest) throws InvalidIdFormatException, ReceiptHandleIsInvalidException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteMessageResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMessage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMessageRequest).withMarshaller((Marshaller)new DeleteMessageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteMessageBatchResponse deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws TooManyEntriesInBatchRequestException, EmptyBatchRequestException, BatchEntryIdsNotDistinctException, InvalidBatchEntryIdException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteMessageBatchResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteMessageBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMessageBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMessageBatchRequest).withMarshaller((Marshaller)new DeleteMessageBatchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteQueueResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQueueRequest).withMarshaller((Marshaller)new DeleteQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetQueueAttributesResponse getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) throws InvalidAttributeNameException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetQueueAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetQueueAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueueAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueueAttributesRequest).withMarshaller((Marshaller)new GetQueueAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetQueueUrlResponse getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) throws QueueDoesNotExistException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetQueueUrlResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetQueueUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueueUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueueUrlRequest).withMarshaller((Marshaller)new GetQueueUrlRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDeadLetterSourceQueuesResponse listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws QueueDoesNotExistException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDeadLetterSourceQueuesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListDeadLetterSourceQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeadLetterSourceQueues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeadLetterSourceQueuesRequest).withMarshaller((Marshaller)new ListDeadLetterSourceQueuesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListQueueTagsResponse listQueueTags(ListQueueTagsRequest listQueueTagsRequest) throws AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListQueueTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListQueueTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueueTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueueTagsRequest).withMarshaller((Marshaller)new ListQueueTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListQueuesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueuesRequest).withMarshaller((Marshaller)new ListQueuesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PurgeQueueResponse purgeQueue(PurgeQueueRequest purgeQueueRequest) throws QueueDoesNotExistException, PurgeQueueInProgressException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PurgeQueueResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PurgeQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurgeQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purgeQueueRequest).withMarshaller((Marshaller)new PurgeQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ReceiveMessageResponse receiveMessage(ReceiveMessageRequest receiveMessageRequest) throws OverLimitException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ReceiveMessageResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ReceiveMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReceiveMessage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)receiveMessageRequest).withMarshaller((Marshaller)new ReceiveMessageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemovePermissionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) throws InvalidMessageContentsException, UnsupportedOperationException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendMessageResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendMessage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendMessageRequest).withMarshaller((Marshaller)new SendMessageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendMessageBatchResponse sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) throws TooManyEntriesInBatchRequestException, EmptyBatchRequestException, BatchEntryIdsNotDistinctException, BatchRequestTooLongException, InvalidBatchEntryIdException, UnsupportedOperationException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendMessageBatchResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendMessageBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendMessageBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendMessageBatchRequest).withMarshaller((Marshaller)new SendMessageBatchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetQueueAttributesResponse setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) throws InvalidAttributeNameException, AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetQueueAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetQueueAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetQueueAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setQueueAttributesRequest).withMarshaller((Marshaller)new SetQueueAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagQueueResponse tagQueue(TagQueueRequest tagQueueRequest) throws AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TagQueueResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TagQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagQueueRequest).withMarshaller((Marshaller)new TagQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagQueueResponse untagQueue(UntagQueueRequest untagQueueRequest) throws AwsServiceException, SdkClientException, SqsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UntagQueueResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UntagQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagQueue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagQueueRequest).withMarshaller((Marshaller)new UntagQueueRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.PurgeQueueInProgress").exceptionBuilderSupplier(PurgeQueueInProgressException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAttributeName").exceptionBuilderSupplier(InvalidAttributeNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.BatchEntryIdsNotDistinct").exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.TooManyEntriesInBatchRequest").exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.BatchRequestTooLong").exceptionBuilderSupplier(BatchRequestTooLongException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIdFormat").exceptionBuilderSupplier(InvalidIdFormatException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OverLimit").exceptionBuilderSupplier(OverLimitException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.NonExistentQueue").exceptionBuilderSupplier(QueueDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueueAlreadyExists").exceptionBuilderSupplier(QueueNameExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.MessageNotInflight").exceptionBuilderSupplier(MessageNotInflightException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMessageContents").exceptionBuilderSupplier(InvalidMessageContentsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.QueueDeletedRecently").exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.EmptyBatchRequest").exceptionBuilderSupplier(EmptyBatchRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWS.SimpleQueueService.InvalidBatchEntryId").exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SqsException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SqsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.22").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SqsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

