/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.services.sqs.internal.batchmanager.BatchingExecutionContext;
import software.amazon.awssdk.services.sqs.internal.batchmanager.BatchingMap;
import software.amazon.awssdk.services.sqs.internal.batchmanager.IdentifiableMessage;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchConfiguration;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public abstract class RequestBatchManager<RequestT, ResponseT, BatchResponseT> {
    public static final Consumer<AwsRequestOverrideConfiguration.Builder> USER_AGENT_APPLIER = b -> b.addApiName(ApiName.builder().version("abm").name("hll").build());
    protected final RequestBatchConfiguration batchConfiguration;
    private final int maxBatchItems;
    private final Duration sendRequestFrequency;
    private final BatchingMap<RequestT, ResponseT> requestsAndResponsesMaps;
    private final ScheduledExecutorService scheduledExecutor;
    private final Set<CompletableFuture<BatchResponseT>> pendingBatchResponses;
    private final Set<CompletableFuture<ResponseT>> pendingResponses;

    protected RequestBatchManager(RequestBatchConfiguration overrideConfiguration, ScheduledExecutorService scheduledExecutor) {
        this.batchConfiguration = overrideConfiguration;
        this.maxBatchItems = this.batchConfiguration.maxBatchItems();
        this.sendRequestFrequency = this.batchConfiguration.sendRequestFrequency();
        this.scheduledExecutor = (ScheduledExecutorService)Validate.notNull((Object)scheduledExecutor, (String)"Null scheduledExecutor", (Object[])new Object[0]);
        this.pendingBatchResponses = ConcurrentHashMap.newKeySet();
        this.pendingResponses = ConcurrentHashMap.newKeySet();
        this.requestsAndResponsesMaps = new BatchingMap(overrideConfiguration);
    }

    public CompletableFuture<ResponseT> batchRequest(RequestT request) {
        CompletableFuture response = new CompletableFuture();
        this.pendingResponses.add(response);
        response.whenComplete((r, t) -> this.pendingResponses.remove(response));
        try {
            String batchKey = this.getBatchKey(request);
            if (this.requestsAndResponsesMaps.contains(batchKey) && this.batchConfiguration.maxBatchBytesSize() > 0) {
                Optional.of(this.requestsAndResponsesMaps.extractBatchIfSizeExceeded(batchKey, request)).filter(extractedEntries -> !extractedEntries.isEmpty()).ifPresent(extractedEntries -> this.manualFlushBuffer(batchKey, (Map<String, BatchingExecutionContext<RequestT, ResponseT>>)extractedEntries));
            }
            this.requestsAndResponsesMaps.put(batchKey, () -> this.scheduleBufferFlush(batchKey, this.sendRequestFrequency.toMillis(), this.scheduledExecutor), request, response);
            Optional.of(this.requestsAndResponsesMaps.extractBatchIfReady(batchKey)).filter(extractedEntries -> !extractedEntries.isEmpty()).ifPresent(extractedEntries -> this.manualFlushBuffer(batchKey, (Map<String, BatchingExecutionContext<RequestT, ResponseT>>)extractedEntries));
        }
        catch (Exception e) {
            response.completeExceptionally(e);
        }
        return response;
    }

    protected abstract CompletableFuture<BatchResponseT> batchAndSend(List<IdentifiableMessage<RequestT>> var1, String var2);

    protected abstract String getBatchKey(RequestT var1);

    protected abstract List<Either<IdentifiableMessage<ResponseT>, IdentifiableMessage<Throwable>>> mapBatchResponse(BatchResponseT var1);

    private void manualFlushBuffer(String batchKey, Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableRequests) {
        this.flushBuffer(batchKey, flushableRequests);
        this.requestsAndResponsesMaps.cancelAndReplaceScheduledFlush(batchKey, this.scheduleBufferFlush(batchKey, this.sendRequestFrequency.toMillis(), this.scheduledExecutor));
    }

    private void flushBuffer(String batchKey, Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableRequests) {
        ArrayList requestEntries = new ArrayList();
        flushableRequests.forEach((contextId, batchExecutionContext) -> requestEntries.add(new IdentifiableMessage((String)contextId, batchExecutionContext.request())));
        if (!requestEntries.isEmpty()) {
            CompletableFuture<BatchResponseT> pendingBatchingRequest = this.batchAndSend(requestEntries, batchKey);
            this.pendingBatchResponses.add(pendingBatchingRequest);
            pendingBatchingRequest.whenComplete((result, ex) -> {
                this.handleAndCompleteResponses((BatchResponseT)result, (Throwable)ex, flushableRequests);
                this.pendingBatchResponses.remove(pendingBatchingRequest);
            });
        }
    }

    private void handleAndCompleteResponses(BatchResponseT batchResult, Throwable exception, Map<String, BatchingExecutionContext<RequestT, ResponseT>> requests) {
        if (exception != null) {
            requests.forEach((contextId, batchExecutionContext) -> batchExecutionContext.response().completeExceptionally(exception));
        } else {
            this.mapBatchResponse(batchResult).forEach(response -> response.map(actualResponse -> ((BatchingExecutionContext)requests.get(actualResponse.id())).response().complete(actualResponse.message()), throwable -> ((BatchingExecutionContext)requests.get(throwable.id())).response().completeExceptionally((Throwable)throwable.message())));
        }
        requests.clear();
    }

    private ScheduledFuture<?> scheduleBufferFlush(String batchKey, long timeOutInMs, ScheduledExecutorService scheduledExecutor) {
        return scheduledExecutor.scheduleAtFixedRate(() -> this.performScheduledFlush(batchKey), timeOutInMs, timeOutInMs, TimeUnit.MILLISECONDS);
    }

    private void performScheduledFlush(String batchKey) {
        Map<String, BatchingExecutionContext<RequestT, ResponseT>> extractedEntries = this.requestsAndResponsesMaps.extractEntriesForScheduledFlush(batchKey, this.maxBatchItems);
        if (!extractedEntries.isEmpty()) {
            this.flushBuffer(batchKey, extractedEntries);
        }
    }

    public void close() {
        this.requestsAndResponsesMaps.forEach((batchKey, batchBuffer) -> {
            this.requestsAndResponsesMaps.cancelScheduledFlush((String)batchKey);
            Map<String, BatchingExecutionContext<RequestT, ResponseT>> extractedEntries = this.requestsAndResponsesMaps.extractBatchIfReady((String)batchKey);
            while (!extractedEntries.isEmpty()) {
                this.flushBuffer((String)batchKey, extractedEntries);
            }
        });
        this.pendingBatchResponses.forEach(future -> future.cancel(true));
        this.pendingResponses.forEach(future -> future.cancel(true));
        this.requestsAndResponsesMaps.clear();
    }
}

