/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelMessageMoveTaskRequest extends SqsRequest implements
        ToCopyableBuilder<CancelMessageMoveTaskRequest.Builder, CancelMessageMoveTaskRequest> {
    private static final SdkField<String> TASK_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskHandle").getter(getter(CancelMessageMoveTaskRequest::taskHandle))
            .setter(setter(Builder::taskHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskHandle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_HANDLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskHandle;

    private CancelMessageMoveTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskHandle = builder.taskHandle;
    }

    /**
     * <p>
     * An identifier associated with a message movement task.
     * </p>
     * 
     * @return An identifier associated with a message movement task.
     */
    public final String taskHandle() {
        return taskHandle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskHandle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMessageMoveTaskRequest)) {
            return false;
        }
        CancelMessageMoveTaskRequest other = (CancelMessageMoveTaskRequest) obj;
        return Objects.equals(taskHandle(), other.taskHandle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelMessageMoveTaskRequest").add("TaskHandle", taskHandle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskHandle":
            return Optional.ofNullable(clazz.cast(taskHandle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskHandle", TASK_HANDLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelMessageMoveTaskRequest, T> g) {
        return obj -> g.apply((CancelMessageMoveTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelMessageMoveTaskRequest> {
        /**
         * <p>
         * An identifier associated with a message movement task.
         * </p>
         * 
         * @param taskHandle
         *        An identifier associated with a message movement task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskHandle(String taskHandle);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String taskHandle;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMessageMoveTaskRequest model) {
            super(model);
            taskHandle(model.taskHandle);
        }

        public final String getTaskHandle() {
            return taskHandle;
        }

        public final void setTaskHandle(String taskHandle) {
            this.taskHandle = taskHandle;
        }

        @Override
        public final Builder taskHandle(String taskHandle) {
            this.taskHandle = taskHandle;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelMessageMoveTaskRequest build() {
            return new CancelMessageMoveTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
