/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.MessageAttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeListCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceiveMessageRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, ReceiveMessageRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueUrl").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::queueUrl)).setter(ReceiveMessageRequest.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::attributeNamesAsStrings)).setter(ReceiveMessageRequest.setter(Builder::attributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<String>> MESSAGE_SYSTEM_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MessageSystemAttributeNames").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::messageSystemAttributeNamesAsStrings)).setter(ReceiveMessageRequest.setter(Builder::messageSystemAttributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSystemAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<String>> MESSAGE_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MessageAttributeNames").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::messageAttributeNames)).setter(ReceiveMessageRequest.setter(Builder::messageAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<Integer> MAX_NUMBER_OF_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxNumberOfMessages").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::maxNumberOfMessages)).setter(ReceiveMessageRequest.setter(Builder::maxNumberOfMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfMessages").build()}).build();
    private static final SdkField<Integer> VISIBILITY_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VisibilityTimeout").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::visibilityTimeout)).setter(ReceiveMessageRequest.setter(Builder::visibilityTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityTimeout").build()}).build();
    private static final SdkField<Integer> WAIT_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitTimeSeconds").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::waitTimeSeconds)).setter(ReceiveMessageRequest.setter(Builder::waitTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitTimeSeconds").build()}).build();
    private static final SdkField<String> RECEIVE_REQUEST_ATTEMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiveRequestAttemptId").getter(ReceiveMessageRequest.getter(ReceiveMessageRequest::receiveRequestAttemptId)).setter(ReceiveMessageRequest.setter(Builder::receiveRequestAttemptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiveRequestAttemptId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, ATTRIBUTE_NAMES_FIELD, MESSAGE_SYSTEM_ATTRIBUTE_NAMES_FIELD, MESSAGE_ATTRIBUTE_NAMES_FIELD, MAX_NUMBER_OF_MESSAGES_FIELD, VISIBILITY_TIMEOUT_FIELD, WAIT_TIME_SECONDS_FIELD, RECEIVE_REQUEST_ATTEMPT_ID_FIELD));
    private final String queueUrl;
    private final List<String> attributeNames;
    private final List<String> messageSystemAttributeNames;
    private final List<String> messageAttributeNames;
    private final Integer maxNumberOfMessages;
    private final Integer visibilityTimeout;
    private final Integer waitTimeSeconds;
    private final String receiveRequestAttemptId;

    private ReceiveMessageRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
        this.messageSystemAttributeNames = builder.messageSystemAttributeNames;
        this.messageAttributeNames = builder.messageAttributeNames;
        this.maxNumberOfMessages = builder.maxNumberOfMessages;
        this.visibilityTimeout = builder.visibilityTimeout;
        this.waitTimeSeconds = builder.waitTimeSeconds;
        this.receiveRequestAttemptId = builder.receiveRequestAttemptId;
    }

    public final String queueUrl() {
        return this.queueUrl;
    }

    @Deprecated
    public final List<QueueAttributeName> attributeNames() {
        return AttributeNameListCopier.copyStringToEnum(this.attributeNames);
    }

    @Deprecated
    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> attributeNamesAsStrings() {
        return this.attributeNames;
    }

    public final List<MessageSystemAttributeName> messageSystemAttributeNames() {
        return MessageSystemAttributeListCopier.copyStringToEnum(this.messageSystemAttributeNames);
    }

    public final boolean hasMessageSystemAttributeNames() {
        return this.messageSystemAttributeNames != null && !(this.messageSystemAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> messageSystemAttributeNamesAsStrings() {
        return this.messageSystemAttributeNames;
    }

    public final boolean hasMessageAttributeNames() {
        return this.messageAttributeNames != null && !(this.messageAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> messageAttributeNames() {
        return this.messageAttributeNames;
    }

    public final Integer maxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public final Integer visibilityTimeout() {
        return this.visibilityTimeout;
    }

    public final Integer waitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    public final String receiveRequestAttemptId() {
        return this.receiveRequestAttemptId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageSystemAttributeNames() ? this.messageSystemAttributeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageAttributeNames() ? this.messageAttributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfMessages());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiveRequestAttemptId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageRequest)) {
            return false;
        }
        ReceiveMessageRequest other = (ReceiveMessageRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNamesAsStrings(), other.attributeNamesAsStrings()) && this.hasMessageSystemAttributeNames() == other.hasMessageSystemAttributeNames() && Objects.equals(this.messageSystemAttributeNamesAsStrings(), other.messageSystemAttributeNamesAsStrings()) && this.hasMessageAttributeNames() == other.hasMessageAttributeNames() && Objects.equals(this.messageAttributeNames(), other.messageAttributeNames()) && Objects.equals(this.maxNumberOfMessages(), other.maxNumberOfMessages()) && Objects.equals(this.visibilityTimeout(), other.visibilityTimeout()) && Objects.equals(this.waitTimeSeconds(), other.waitTimeSeconds()) && Objects.equals(this.receiveRequestAttemptId(), other.receiveRequestAttemptId());
    }

    public final String toString() {
        return ToString.builder((String)"ReceiveMessageRequest").add("QueueUrl", (Object)this.queueUrl()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNamesAsStrings() : null).add("MessageSystemAttributeNames", this.hasMessageSystemAttributeNames() ? this.messageSystemAttributeNamesAsStrings() : null).add("MessageAttributeNames", this.hasMessageAttributeNames() ? this.messageAttributeNames() : null).add("MaxNumberOfMessages", (Object)this.maxNumberOfMessages()).add("VisibilityTimeout", (Object)this.visibilityTimeout()).add("WaitTimeSeconds", (Object)this.waitTimeSeconds()).add("ReceiveRequestAttemptId", (Object)this.receiveRequestAttemptId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNamesAsStrings()));
            }
            case "MessageSystemAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.messageSystemAttributeNamesAsStrings()));
            }
            case "MessageAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.messageAttributeNames()));
            }
            case "MaxNumberOfMessages": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfMessages()));
            }
            case "VisibilityTimeout": {
                return Optional.ofNullable(clazz.cast(this.visibilityTimeout()));
            }
            case "WaitTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.waitTimeSeconds()));
            }
            case "ReceiveRequestAttemptId": {
                return Optional.ofNullable(clazz.cast(this.receiveRequestAttemptId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceiveMessageRequest, T> g) {
        return obj -> g.apply((ReceiveMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> messageSystemAttributeNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> messageAttributeNames = DefaultSdkAutoConstructList.getInstance();
        private Integer maxNumberOfMessages;
        private Integer visibilityTimeout;
        private Integer waitTimeSeconds;
        private String receiveRequestAttemptId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.attributeNamesWithStrings(model.attributeNames);
            this.messageSystemAttributeNamesWithStrings(model.messageSystemAttributeNames);
            this.messageAttributeNames(model.messageAttributeNames);
            this.maxNumberOfMessages(model.maxNumberOfMessages);
            this.visibilityTimeout(model.visibilityTimeout);
            this.waitTimeSeconds(model.waitTimeSeconds);
            this.receiveRequestAttemptId(model.receiveRequestAttemptId);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        @Deprecated
        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        @Deprecated
        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        @Deprecated
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder attributeNamesWithStrings(String ... attributeNames) {
            this.attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        @Deprecated
        public final Builder attributeNames(Collection<QueueAttributeName> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder attributeNames(QueueAttributeName ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final Collection<String> getMessageSystemAttributeNames() {
            if (this.messageSystemAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messageSystemAttributeNames;
        }

        public final void setMessageSystemAttributeNames(Collection<String> messageSystemAttributeNames) {
            this.messageSystemAttributeNames = MessageSystemAttributeListCopier.copy(messageSystemAttributeNames);
        }

        @Override
        public final Builder messageSystemAttributeNamesWithStrings(Collection<String> messageSystemAttributeNames) {
            this.messageSystemAttributeNames = MessageSystemAttributeListCopier.copy(messageSystemAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageSystemAttributeNamesWithStrings(String ... messageSystemAttributeNames) {
            this.messageSystemAttributeNamesWithStrings(Arrays.asList(messageSystemAttributeNames));
            return this;
        }

        @Override
        public final Builder messageSystemAttributeNames(Collection<MessageSystemAttributeName> messageSystemAttributeNames) {
            this.messageSystemAttributeNames = MessageSystemAttributeListCopier.copyEnumToString(messageSystemAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageSystemAttributeNames(MessageSystemAttributeName ... messageSystemAttributeNames) {
            this.messageSystemAttributeNames(Arrays.asList(messageSystemAttributeNames));
            return this;
        }

        public final Collection<String> getMessageAttributeNames() {
            if (this.messageAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messageAttributeNames;
        }

        public final void setMessageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
        }

        @Override
        public final Builder messageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageAttributeNames(String ... messageAttributeNames) {
            this.messageAttributeNames(Arrays.asList(messageAttributeNames));
            return this;
        }

        public final Integer getMaxNumberOfMessages() {
            return this.maxNumberOfMessages;
        }

        public final void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
        }

        @Override
        public final Builder maxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
            return this;
        }

        public final Integer getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final Integer getWaitTimeSeconds() {
            return this.waitTimeSeconds;
        }

        public final void setWaitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
        }

        @Override
        public final Builder waitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
            return this;
        }

        public final String getReceiveRequestAttemptId() {
            return this.receiveRequestAttemptId;
        }

        public final void setReceiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
        }

        @Override
        public final Builder receiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReceiveMessageRequest build() {
            return new ReceiveMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReceiveMessageRequest> {
        public Builder queueUrl(String var1);

        @Deprecated
        public Builder attributeNamesWithStrings(Collection<String> var1);

        @Deprecated
        public Builder attributeNamesWithStrings(String ... var1);

        @Deprecated
        public Builder attributeNames(Collection<QueueAttributeName> var1);

        @Deprecated
        public Builder attributeNames(QueueAttributeName ... var1);

        public Builder messageSystemAttributeNamesWithStrings(Collection<String> var1);

        public Builder messageSystemAttributeNamesWithStrings(String ... var1);

        public Builder messageSystemAttributeNames(Collection<MessageSystemAttributeName> var1);

        public Builder messageSystemAttributeNames(MessageSystemAttributeName ... var1);

        public Builder messageAttributeNames(Collection<String> var1);

        public Builder messageAttributeNames(String ... var1);

        public Builder maxNumberOfMessages(Integer var1);

        public Builder visibilityTimeout(Integer var1);

        public Builder waitTimeSeconds(Integer var1);

        public Builder receiveRequestAttemptId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

