/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntryListCopier;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMessageBatchRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, DeleteMessageBatchRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueUrl").getter(DeleteMessageBatchRequest.getter(DeleteMessageBatchRequest::queueUrl)).setter(DeleteMessageBatchRequest.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build();
    private static final SdkField<List<DeleteMessageBatchRequestEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(DeleteMessageBatchRequest.getter(DeleteMessageBatchRequest::entries)).setter(DeleteMessageBatchRequest.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteMessageBatchRequestEntry").build(), ListTrait.builder().memberLocationName("DeleteMessageBatchRequestEntry").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteMessageBatchRequestEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteMessageBatchRequestEntry").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, ENTRIES_FIELD));
    private final String queueUrl;
    private final List<DeleteMessageBatchRequestEntry> entries;

    private DeleteMessageBatchRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    public final String queueUrl() {
        return this.queueUrl;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<DeleteMessageBatchRequestEntry> entries() {
        return this.entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequest)) {
            return false;
        }
        DeleteMessageBatchRequest other = (DeleteMessageBatchRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteMessageBatchRequest").add("QueueUrl", (Object)this.queueUrl()).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMessageBatchRequest, T> g) {
        return obj -> g.apply((DeleteMessageBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<DeleteMessageBatchRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.entries(model.entries);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<DeleteMessageBatchRequestEntry.Builder> getEntries() {
            if (this.entries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entries != null ? (Collection)this.entries.stream().map(DeleteMessageBatchRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<DeleteMessageBatchRequestEntry> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(DeleteMessageBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<DeleteMessageBatchRequestEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (DeleteMessageBatchRequestEntry)((DeleteMessageBatchRequestEntry.Builder)DeleteMessageBatchRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<DeleteMessageBatchRequestEntry.BuilderImpl> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMessageBatchRequest build() {
            return new DeleteMessageBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteMessageBatchRequest> {
        public Builder queueUrl(String var1);

        public Builder entries(Collection<DeleteMessageBatchRequestEntry> var1);

        public Builder entries(DeleteMessageBatchRequestEntry ... var1);

        public Builder entries(Consumer<DeleteMessageBatchRequestEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

