/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.MessageAttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiveMessageRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, ReceiveMessageRequest> {
    private final String queueUrl;
    private final List<String> attributeNames;
    private final List<String> messageAttributeNames;
    private final Integer maxNumberOfMessages;
    private final Integer visibilityTimeout;
    private final Integer waitTimeSeconds;
    private final String receiveRequestAttemptId;

    private ReceiveMessageRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
        this.messageAttributeNames = builder.messageAttributeNames;
        this.maxNumberOfMessages = builder.maxNumberOfMessages;
        this.visibilityTimeout = builder.visibilityTimeout;
        this.waitTimeSeconds = builder.waitTimeSeconds;
        this.receiveRequestAttemptId = builder.receiveRequestAttemptId;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<QueueAttributeName> attributeNames() {
        return TypeConverter.convert(this.attributeNames, QueueAttributeName::fromValue);
    }

    public List<String> attributeNamesStrings() {
        return this.attributeNames;
    }

    public List<String> messageAttributeNames() {
        return this.messageAttributeNames;
    }

    public Integer maxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public Integer visibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Integer waitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    public String receiveRequestAttemptId() {
        return this.receiveRequestAttemptId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNamesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfMessages());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiveRequestAttemptId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageRequest)) {
            return false;
        }
        ReceiveMessageRequest other = (ReceiveMessageRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.attributeNamesStrings(), other.attributeNamesStrings()) && Objects.equals(this.messageAttributeNames(), other.messageAttributeNames()) && Objects.equals(this.maxNumberOfMessages(), other.maxNumberOfMessages()) && Objects.equals(this.visibilityTimeout(), other.visibilityTimeout()) && Objects.equals(this.waitTimeSeconds(), other.waitTimeSeconds()) && Objects.equals(this.receiveRequestAttemptId(), other.receiveRequestAttemptId());
    }

    public String toString() {
        return ToString.builder((String)"ReceiveMessageRequest").add("QueueUrl", (Object)this.queueUrl()).add("AttributeNames", this.attributeNamesStrings()).add("MessageAttributeNames", this.messageAttributeNames()).add("MaxNumberOfMessages", (Object)this.maxNumberOfMessages()).add("VisibilityTimeout", (Object)this.visibilityTimeout()).add("WaitTimeSeconds", (Object)this.waitTimeSeconds()).add("ReceiveRequestAttemptId", (Object)this.receiveRequestAttemptId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "AttributeNames": {
                return Optional.of(clazz.cast(this.attributeNamesStrings()));
            }
            case "MessageAttributeNames": {
                return Optional.of(clazz.cast(this.messageAttributeNames()));
            }
            case "MaxNumberOfMessages": {
                return Optional.of(clazz.cast(this.maxNumberOfMessages()));
            }
            case "VisibilityTimeout": {
                return Optional.of(clazz.cast(this.visibilityTimeout()));
            }
            case "WaitTimeSeconds": {
                return Optional.of(clazz.cast(this.waitTimeSeconds()));
            }
            case "ReceiveRequestAttemptId": {
                return Optional.of(clazz.cast(this.receiveRequestAttemptId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames;
        private List<String> messageAttributeNames;
        private Integer maxNumberOfMessages;
        private Integer visibilityTimeout;
        private Integer waitTimeSeconds;
        private String receiveRequestAttemptId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageRequest model) {
            this.queueUrl(model.queueUrl);
            this.attributeNames(model.attributeNames);
            this.messageAttributeNames(model.messageAttributeNames);
            this.maxNumberOfMessages(model.maxNumberOfMessages);
            this.visibilityTimeout(model.visibilityTimeout);
            this.waitTimeSeconds(model.waitTimeSeconds);
            this.receiveRequestAttemptId(model.receiveRequestAttemptId);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public final Collection<String> getMessageAttributeNames() {
            return this.messageAttributeNames;
        }

        @Override
        public final Builder messageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageAttributeNames(String ... messageAttributeNames) {
            this.messageAttributeNames(Arrays.asList(messageAttributeNames));
            return this;
        }

        public final void setMessageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
        }

        public final Integer getMaxNumberOfMessages() {
            return this.maxNumberOfMessages;
        }

        @Override
        public final Builder maxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
            return this;
        }

        public final void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
        }

        public final Integer getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        public final Integer getWaitTimeSeconds() {
            return this.waitTimeSeconds;
        }

        @Override
        public final Builder waitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
            return this;
        }

        public final void setWaitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
        }

        public final String getReceiveRequestAttemptId() {
            return this.receiveRequestAttemptId;
        }

        @Override
        public final Builder receiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
            return this;
        }

        public final void setReceiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ReceiveMessageRequest build() {
            return new ReceiveMessageRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, ReceiveMessageRequest> {
        public Builder queueUrl(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder messageAttributeNames(Collection<String> var1);

        public Builder messageAttributeNames(String ... var1);

        public Builder maxNumberOfMessages(Integer var1);

        public Builder visibilityTimeout(Integer var1);

        public Builder waitTimeSeconds(Integer var1);

        public Builder receiveRequestAttemptId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

