/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        Map<String, MessageAttributeValue> messageAttributes;
        if (sendMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)sendMessageRequest, "SQSClient");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)sendMessageRequest.queueUrl()));
        }
        if (sendMessageRequest.messageBody() != null) {
            request.addParameter("MessageBody", StringUtils.fromString((String)sendMessageRequest.messageBody()));
        }
        if (sendMessageRequest.delaySeconds() != null) {
            request.addParameter("DelaySeconds", StringUtils.fromInteger((Integer)sendMessageRequest.delaySeconds()));
        }
        if ((messageAttributes = sendMessageRequest.messageAttributes()) != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    List<ByteBuffer> binaryListValuesList;
                    List<String> stringListValuesList;
                    if (entry.getValue().stringValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)entry.getValue().stringValue()));
                    }
                    if (entry.getValue().binaryValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)entry.getValue().binaryValue()));
                    }
                    if ((stringListValuesList = entry.getValue().stringListValues()) != null) {
                        if (!stringListValuesList.isEmpty()) {
                            int stringListValuesListIndex = 1;
                            for (String stringListValuesListValue : stringListValuesList) {
                                if (stringListValuesListValue != null) {
                                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString((String)stringListValuesListValue));
                                }
                                ++stringListValuesListIndex;
                            }
                        } else {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue", "");
                        }
                    }
                    if ((binaryListValuesList = entry.getValue().binaryListValues()) != null) {
                        if (!binaryListValuesList.isEmpty()) {
                            int binaryListValuesListIndex = 1;
                            for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                                if (binaryListValuesListValue != null) {
                                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer((ByteBuffer)binaryListValuesListValue));
                                }
                                ++binaryListValuesListIndex;
                            }
                        } else {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue", "");
                        }
                    }
                    if (entry.getValue().dataType() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)entry.getValue().dataType()));
                    }
                }
                ++messageAttributesListIndex;
            }
        }
        if (sendMessageRequest.messageDeduplicationId() != null) {
            request.addParameter("MessageDeduplicationId", StringUtils.fromString((String)sendMessageRequest.messageDeduplicationId()));
        }
        if (sendMessageRequest.messageGroupId() != null) {
            request.addParameter("MessageGroupId", StringUtils.fromString((String)sendMessageRequest.messageGroupId()));
        }
        return request;
    }
}

