/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse;

public class ListQueueTagsResponseUnmarshaller
implements Unmarshaller<ListQueueTagsResponse, StaxUnmarshallerContext> {
    private static final ListQueueTagsResponseUnmarshaller INSTANCE = new ListQueueTagsResponseUnmarshaller();

    public ListQueueTagsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListQueueTagsResponse.Builder listQueueTagsResponse;
        block5: {
            listQueueTagsResponse = ListQueueTagsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            HashMap<String, String> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listQueueTagsResponse.tags(tags);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("Tag", targetDepth)) continue;
                    if (tags == null) {
                        tags = new HashMap<String, String>();
                    }
                    Map.Entry<String, String> entry = TagsMapEntryUnmarshaller.getInstance().unmarshall(context);
                    tags.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listQueueTagsResponse.tags(tags);
        }
        return (ListQueueTagsResponse)((Object)listQueueTagsResponse.build());
    }

    public static ListQueueTagsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class TagsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final TagsMapEntryUnmarshaller INSTANCE = new TagsMapEntryUnmarshaller();

        private TagsMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static TagsMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

