/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;

public class GetQueueUrlRequestMarshaller
implements Marshaller<Request<GetQueueUrlRequest>, GetQueueUrlRequest> {
    public Request<GetQueueUrlRequest> marshall(GetQueueUrlRequest getQueueUrlRequest) {
        if (getQueueUrlRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getQueueUrlRequest, "SQSClient");
        request.addParameter("Action", "GetQueueUrl");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (getQueueUrlRequest.queueName() != null) {
            request.addParameter("QueueName", StringUtils.fromString((String)getQueueUrlRequest.queueName()));
        }
        if (getQueueUrlRequest.queueOwnerAWSAccountId() != null) {
            request.addParameter("QueueOwnerAWSAccountId", StringUtils.fromString((String)getQueueUrlRequest.queueOwnerAWSAccountId()));
        }
        return request;
    }
}

