/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntryListCopier;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeMessageVisibilityBatchRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, ChangeMessageVisibilityBatchRequest> {
    private final String queueUrl;
    private final List<ChangeMessageVisibilityBatchRequestEntry> entries;

    private ChangeMessageVisibilityBatchRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<ChangeMessageVisibilityBatchRequestEntry> entries() {
        return this.entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.entries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchRequest)) {
            return false;
        }
        ChangeMessageVisibilityBatchRequest other = (ChangeMessageVisibilityBatchRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.entries(), other.entries());
    }

    public String toString() {
        return ToString.builder((String)"ChangeMessageVisibilityBatchRequest").add("QueueUrl", (Object)this.queueUrl()).add("Entries", this.entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "Entries": {
                return Optional.of(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<ChangeMessageVisibilityBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchRequest model) {
            this.queueUrl(model.queueUrl);
            this.entries(model.entries);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<ChangeMessageVisibilityBatchRequestEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(ChangeMessageVisibilityBatchRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
            this.entries = ChangeMessageVisibilityBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ChangeMessageVisibilityBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<ChangeMessageVisibilityBatchRequestEntry.BuilderImpl> entries) {
            this.entries = ChangeMessageVisibilityBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ChangeMessageVisibilityBatchRequest build() {
            return new ChangeMessageVisibilityBatchRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, ChangeMessageVisibilityBatchRequest> {
        public Builder queueUrl(String var1);

        public Builder entries(Collection<ChangeMessageVisibilityBatchRequestEntry> var1);

        public Builder entries(ChangeMessageVisibilityBatchRequestEntry ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

