/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest;

public class ListQueueTagsRequestMarshaller
implements Marshaller<Request<ListQueueTagsRequest>, ListQueueTagsRequest> {
    public Request<ListQueueTagsRequest> marshall(ListQueueTagsRequest listQueueTagsRequest) {
        if (listQueueTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listQueueTagsRequest, "SQSClient");
        request.addParameter("Action", "ListQueueTags");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (listQueueTagsRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)listQueueTagsRequest.queueUrl()));
        }
        return request;
    }
}

