/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageBatchRequestEntry
implements ToCopyableBuilder<Builder, SendMessageBatchRequestEntry> {
    private final String id;
    private final String messageBody;
    private final Integer delaySeconds;
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final String messageDeduplicationId;
    private final String messageGroupId;

    private SendMessageBatchRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.messageBody = builder.messageBody;
        this.delaySeconds = builder.delaySeconds;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    public String id() {
        return this.id;
    }

    public String messageBody() {
        return this.messageBody;
    }

    public Integer delaySeconds() {
        return this.delaySeconds;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public String messageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public String messageGroupId() {
        return this.messageGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.delaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeduplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequestEntry)) {
            return false;
        }
        SendMessageBatchRequestEntry other = (SendMessageBatchRequestEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.messageBody(), other.messageBody()) && Objects.equals(this.delaySeconds(), other.delaySeconds()) && Objects.equals(this.messageAttributes(), other.messageAttributes()) && Objects.equals(this.messageDeduplicationId(), other.messageDeduplicationId()) && Objects.equals(this.messageGroupId(), other.messageGroupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.messageBody() != null) {
            sb.append("MessageBody: ").append(this.messageBody()).append(",");
        }
        if (this.delaySeconds() != null) {
            sb.append("DelaySeconds: ").append(this.delaySeconds()).append(",");
        }
        if (this.messageAttributes() != null) {
            sb.append("MessageAttributes: ").append(this.messageAttributes()).append(",");
        }
        if (this.messageDeduplicationId() != null) {
            sb.append("MessageDeduplicationId: ").append(this.messageDeduplicationId()).append(",");
        }
        if (this.messageGroupId() != null) {
            sb.append("MessageGroupId: ").append(this.messageGroupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "MessageBody": {
                return Optional.of(clazz.cast(this.messageBody()));
            }
            case "DelaySeconds": {
                return Optional.of(clazz.cast(this.delaySeconds()));
            }
            case "MessageAttributes": {
                return Optional.of(clazz.cast(this.messageAttributes()));
            }
            case "MessageDeduplicationId": {
                return Optional.of(clazz.cast(this.messageDeduplicationId()));
            }
            case "MessageGroupId": {
                return Optional.of(clazz.cast(this.messageGroupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String messageBody;
        private Integer delaySeconds;
        private Map<String, MessageAttributeValue> messageAttributes;
        private String messageDeduplicationId;
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchRequestEntry model) {
            this.id(model.id);
            this.messageBody(model.messageBody);
            this.delaySeconds(model.delaySeconds);
            this.messageAttributes(model.messageAttributes);
            this.messageDeduplicationId(model.messageDeduplicationId);
            this.messageGroupId(model.messageGroupId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public final Integer getDelaySeconds() {
            return this.delaySeconds;
        }

        @Override
        public final Builder delaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        public final void setDelaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return this.messageAttributes != null ? CollectionUtils.mapValues(this.messageAttributes, MessageAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        public final String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        public final String getMessageGroupId() {
            return this.messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        public SendMessageBatchRequestEntry build() {
            return new SendMessageBatchRequestEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendMessageBatchRequestEntry> {
        public Builder id(String var1);

        public Builder messageBody(String var1);

        public Builder delaySeconds(Integer var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder messageDeduplicationId(String var1);

        public Builder messageGroupId(String var1);
    }
}

