/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntryListCopier;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteMessageBatchResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteMessageBatchResponse> {
    private final List<DeleteMessageBatchResultEntry> successful;
    private final List<BatchResultErrorEntry> failed;

    private DeleteMessageBatchResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public List<DeleteMessageBatchResultEntry> successful() {
        return this.successful;
    }

    public List<BatchResultErrorEntry> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchResponse)) {
            return false;
        }
        DeleteMessageBatchResponse other = (DeleteMessageBatchResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.failed(), other.failed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.successful() != null) {
            sb.append("Successful: ").append(this.successful()).append(",");
        }
        if (this.failed() != null) {
            sb.append("Failed: ").append(this.failed()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.of(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.of(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeleteMessageBatchResultEntry> successful;
        private List<BatchResultErrorEntry> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchResponse model) {
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final Collection<DeleteMessageBatchResultEntry.Builder> getSuccessful() {
            return this.successful != null ? (Collection)this.successful.stream().map(DeleteMessageBatchResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<DeleteMessageBatchResultEntry> successful) {
            this.successful = DeleteMessageBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(DeleteMessageBatchResultEntry ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<DeleteMessageBatchResultEntry.BuilderImpl> successful) {
            this.successful = DeleteMessageBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        public final Collection<BatchResultErrorEntry.Builder> getFailed() {
            return this.failed != null ? (Collection)this.failed.stream().map(BatchResultErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        public DeleteMessageBatchResponse build() {
            return new DeleteMessageBatchResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteMessageBatchResponse> {
        public Builder successful(Collection<DeleteMessageBatchResultEntry> var1);

        public Builder successful(DeleteMessageBatchResultEntry ... var1);

        public Builder failed(Collection<BatchResultErrorEntry> var1);

        public Builder failed(BatchResultErrorEntry ... var1);
    }
}

