/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;

public class PurgeQueueRequestMarshaller
implements Marshaller<Request<PurgeQueueRequest>, PurgeQueueRequest> {
    public Request<PurgeQueueRequest> marshall(PurgeQueueRequest purgeQueueRequest) {
        if (purgeQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purgeQueueRequest, "SQSClient");
        request.addParameter("Action", "PurgeQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (purgeQueueRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)purgeQueueRequest.queueUrl()));
        }
        return request;
    }
}

