/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiveMessageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ReceiveMessageResponse> {
    private final List<Message> messages;

    private ReceiveMessageResponse(BuilderImpl builder) {
        this.messages = builder.messages;
    }

    public List<Message> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messages() == null ? 0 : this.messages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse other = (ReceiveMessageResponse)((Object)obj);
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        return other.messages() == null || other.messages().equals(this.messages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.messages() != null) {
            sb.append("Messages: ").append(this.messages()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Messages": {
                return Optional.of(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Message> messages;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageResponse model) {
            this.messages(model.messages);
        }

        public final Collection<Message.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(Message::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessageListCopier.copyFromBuilder(messages);
        }

        public ReceiveMessageResponse build() {
            return new ReceiveMessageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiveMessageResponse> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);
    }
}

