/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetQueueAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetQueueAttributesRequest> {
    private final String queueUrl;
    private final List<String> attributeNames;

    private GetQueueAttributesRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<QueueAttributeName> attributeNames() {
        return TypeConverter.convert(this.attributeNames, QueueAttributeName::fromValue);
    }

    public List<String> attributeNamesStrings() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.attributeNamesStrings() == null ? 0 : this.attributeNamesStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.attributeNamesStrings() == null ^ this.attributeNamesStrings() == null) {
            return false;
        }
        return other.attributeNamesStrings() == null || other.attributeNamesStrings().equals(this.attributeNamesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.attributeNamesStrings() != null) {
            sb.append("AttributeNames: ").append(this.attributeNamesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "AttributeNames": {
                return Optional.of(clazz.cast(this.attributeNamesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesRequest model) {
            this.queueUrl(model.queueUrl);
            this.attributeNames(model.attributeNames);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public GetQueueAttributesRequest build() {
            return new GetQueueAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetQueueAttributesRequest> {
        public Builder queueUrl(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

