/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteMessageBatchRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteMessageBatchRequest> {
    private final String queueUrl;
    private final List<DeleteMessageBatchRequestEntry> entries;

    private DeleteMessageBatchRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<DeleteMessageBatchRequestEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.entries() == null ? 0 : this.entries().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequest)) {
            return false;
        }
        DeleteMessageBatchRequest other = (DeleteMessageBatchRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        return other.entries() == null || other.entries().equals(this.entries());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.entries() != null) {
            sb.append("Entries: ").append(this.entries()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "Entries": {
                return Optional.of(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<DeleteMessageBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchRequest model) {
            this.queueUrl(model.queueUrl);
            this.entries(model.entries);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<DeleteMessageBatchRequestEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(DeleteMessageBatchRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<DeleteMessageBatchRequestEntry> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(DeleteMessageBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<DeleteMessageBatchRequestEntry.BuilderImpl> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        public DeleteMessageBatchRequest build() {
            return new DeleteMessageBatchRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteMessageBatchRequest> {
        public Builder queueUrl(String var1);

        public Builder entries(Collection<DeleteMessageBatchRequestEntry> var1);

        public Builder entries(DeleteMessageBatchRequestEntry ... var1);
    }
}

